<?php

declare(strict_types=1);

namespace Erlage\Photogram\Data\Models\User;

use Erlage\Photogram\Data\Dtos\Common\UserIdsDTO;
use Erlage\Photogram\Data\Dtos\User\UserDisplayImageDTO;
use Erlage\Photogram\Data\Dtos\User\UserMetaPushSettingsDTO;

trait TraitUserProperties
{
    // primary key

    /**
     * @var string
     */
    protected $id;

    // creds

    /**
     * @var string
     */
    protected $email;

    /**
     * @var string
     */
    protected $username;

    /**
     * @var string
     */
    protected $password;

    // display

    /**
     * @var string
     */
    protected $displayName;

    /**
     * @var string
     */
    protected $displayBio;

    /**
     * @var UserDisplayImageDTO
     */
    protected $displayImage;

    /**
     * @var string
     */
    protected $displayWeb;

    // meta

    /**
     * @var string
     */
    protected $metaAccess;

    /**
     * @var string
     */
    protected $metaIsPrivate;

    /**
     * @var string
     */
    protected $metaIsEmailVerified;

    /**
     * @var string
     */
    protected $metaLastActive;

    /**
     * @var UserMetaPushSettingsDTO
     */
    protected $metaPushSettings;

    // cache

    /**
     * @var string
     */
    protected $cachePostsCount;

    /**
     * @var string
     */
    protected $cacheFollowersCount;

    /**
     * @var string
     */
    protected $cacheFollowingsCount;

    // server-only attributes start

    /**
     * @var UserIdsDTO
     */
    protected $cacheBlockedUserIds;

    // server-only attributes end

    // stamps

    /**
     * @var string
     */
    protected $stampRegistration;

    /**
     * @var string
     */
    protected $stampLastUpdate;
}
